/* --COPYRIGHT--,BSD_EX
 * Copyright (c) 2012, Texas Instruments Incorporated
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * *  Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * *  Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * *  Neither the name of Texas Instruments Incorporated nor the names of
 *    its contributors may be used to endorse or promote products derived
 *    from this software without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
 * AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
 * THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR
 * PURPOSE ARE DISCLAIMED. IN NO EVENT SHALL THE COPYRIGHT OWNER OR
 * CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL,
 * EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
 * PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF USE, DATA, OR PROFITS;
 * OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
 * WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR
 * OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
 * EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 *******************************************************************************
 * 
 *                       MSP430 CODE EXAMPLE DISCLAIMER
 *
 * MSP430 code examples are self-contained low-level programs that typically
 * demonstrate a single peripheral function or device feature in a highly
 * concise manner. For this the code may rely on the device???s power-on default
 * register values and settings such as the clock configuration and care must
 * be taken when combining code from several examples to avoid potential side
 * effects. Also see www.ti.com/grace for a GUI- and www.ti.com/msp430ware
 * for an API functional library-approach to peripheral configuration.
 *
 * --/COPYRIGHT--*/
//******************************************************************************
//   MSP430F673x Demo - MPY32, Saturation mode overflow test
//
//   Description: The example illustrates a special case showing overflow.
//   The addition result of 2 positive numbers may exceed the highest positive
//   number (0x7FFF FFFF for 32 bit result) due to overflow indicating a
//   negative result. By having the saturation mode enabled, this result can be
//   truncated off to this highest positive number. Results with and without
//   saturation mode are shown in result variable and RESHI, RESLO registers
//   respectively.
//
//   ACLK = 32.768kHz, MCLK = SMCLK = default DCO
//
//                MSP430F673x
//             -----------------
//         /|\|                 |
//          | |                 |
//          --|RST              |
//            |                 |
//            |                 |
//
//   M. Swanson
//   Texas Instruments Inc.
//   December 2011
//   Built with CCS Version: 5.1.0 and IAR Embedded Workbench Version: 5.40.1
//******************************************************************************
#include <msp430.h>

unsigned long result;                       // global variable for multiply
                                            // result

void main(void)
{
    WDTCTL = WDTPW | WDTHOLD;               // Stop WDT

    MPY32CTL0 = MPYSAT;                     // Enable saturation mode

    RES3 = 0;
    RES2 = 0;
    //------32-bit Result of a multiply operation (not shown) in RES0 and RES1------
    RES1 = 0x7FFF;                          // Pre-load result registers
    RES0 = 0xFFFD;

    MACS = 0x05;                            // Add 5 to previous result
    OP2 = 0x01;
    __no_operation();                       // Wait for result to become ready
    __no_operation();
    __no_operation();
    __no_operation();
    __no_operation();

    result = RESHI;                         // Load RESHI word result
    result = (result << 16) | RESLO;        // Shift RESHI left and concat with
                                            // RESLO word result

    MPY32CTL0 &= ~MPYSAT;                   // Clear saturation mode

    __bis_SR_register(LPM4_bits);           // LPM4
    __no_operation();                       // For debugger
}

